# SaveData_Facade
# Z[uf[^p`oh
# Author:: fukuyama
# Date:: 2007/06/08
# Copyright:: Copyright (C) 2005-2007 rgss-lib

module DQ
  
  module SaveData_Facade
    DATA_PATH = '.'
    INDEX_FILENAME = 'SaveDataList.rxdata'
    
    module_function
    
    # Z[uf[^CfbNXt@C邩H
    def exist_index?
      return FileTest.exist?(make_index_filename())
    end
    
    # Z[uf[^CfbNXt@C̍쐬
    def make_index_filename
      return DATA_PATH + '/' + INDEX_FILENAME
    end
    
    # Z[uf[^̓ǂݍ
    def load(index)
      scene_save = $scene
      scene_dumy = ::Scene_Load.new
      scene_dumy.on_decision(DATA_PATH + '/' + scene_dumy.make_filename(index))
      $scene = scene_save
      $game_temp.last_file_index = index
      if Switches.exist?('DQ_DATA_LOAD')
        Switches['DQ_DATA_LOAD'] = true
      end
    end
    
    # Z[uf[^̏
    def save(index,name,lv,comment)
      savedata_list = load_index
      savedata = Game_SaveData.new
      savedata.name     = name
      savedata.lv       = lv
      savedata.comment  = comment
      savedata.playtime = Graphics.frame_count
      savedata_list[index] = savedata
      save_index(savedata_list)
      
      scene_save = $scene
      scene_dumy = ::Scene_Save.new
      scene_dumy.on_decision(DATA_PATH + '/' + scene_dumy.make_filename(index))
      $scene = scene_save
      $game_temp.last_file_index = index
      if Switches.exist?('DQ_DATA_LOAD')
        Switches['DQ_DATA_LOAD'] = false
      end
    end
    
    # Z[uf[^̍폜
    def delete(index)
      savedata_list = load_index
      savedata_list[index] = nil
      save_index(savedata_list)
      
      scene_save = $scene
      scene_dumy = ::Scene_File.new(nil)
      File.delete(DATA_PATH + '/' + scene_dumy.make_filename(index))
      $scene = scene_save
    end
    
    # Z[uf[^CfbNX̓ǂݍ
    def load_index
      filename = make_index_filename()
      savedata_list = [nil] * (4 * TITLE_SAVE_DATA_PAGE_MAX)
      if FileTest.exist?(filename)
        File.open(filename, "rb") do |file|
          data = Marshal.load(file)
          num = [data.size,savedata_list.size].min
          num.times do |i|
            savedata_list[i] = data[i]
          end
        end
      end
      return savedata_list
    end
    
    # Z[uf[^CfbNX̏
    def save_index(savedata_list)
      filename = make_index_filename()
      File.open(filename, "wb") do |file|
        Marshal.dump(savedata_list,file)
      end
      return savedata_list
    end
    
    # ^CX^vŐṼt@CCfbNX擾
    def latest_save_index
      index = 0
      scene_dumy = ::Scene_Save.new
      latest_time = Time.at(0)
      for i in 0 ... (4 * TITLE_SAVE_DATA_PAGE_MAX)
        filename = DATA_PATH + '/' + scene_dumy.make_filename(i)
        if FileTest.exist?(filename)
          file = File.open(filename, "r")
          if file.mtime > latest_time
            latest_time = file.mtime
            index = i
          end
          file.close
        end
      end
      return index
    end
  end
  
end
